<?php
/**
 * Shortcodes
 *
 * @package     AutomatorWP\Link\Shortcodes
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * [automatorwp_link]
 *
 * @since 1.0.0
 *
 * @param array     $atts       Shortcode's attributes
 * @param string    $content    Shortcode's content
 *
 * @return string
 */
function automatorwp_link_shortcode( $atts = array(), $content = '' ) {

    global $post;

    // Get the received shortcode attributes
    $atts = shortcode_atts( array(
        'trigger'   => '',
        'label'     => __( 'Click me!', 'automatorwp-pro' ),
        'href'      => '',
        'id'        => '',
        'class'     => '',
        'target'    => '_self',
        'title'    => '',
    ), $atts, 'automatorwp_link' );

    $post_id = ( $post ? $post->ID : 0 );

    ob_start(); ?>
    <a data-trigger="<?php echo esc_attr( $atts['trigger'] ); ?>"
       href="<?php echo esc_attr( $atts['href'] ); ?>"
       id="<?php echo esc_attr( $atts['id'] ); ?>"
       class="automatorwp-link <?php echo esc_attr( $atts['class'] ); ?>"
       target="<?php echo esc_attr( $atts['target'] ); ?>"
       title="<?php echo esc_attr( $atts['title'] ); ?>"
       data-post="<?php echo esc_attr( $post_id ); ?>"
    ><?php echo $atts['label']; ?></a>
    <?php $output = ob_get_clean();

    // Return the shortcode output
    return $output;

}
add_shortcode( 'automatorwp_link', 'automatorwp_link_shortcode' );